/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.client.inventory.module;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import slimeknights.mantle.client.screen.ElementScreen;
import slimeknights.mantle.client.screen.ModuleScreen;
import slimeknights.mantle.client.screen.MultiModuleScreen;
import slimeknights.mantle.client.screen.ScalableElementScreen;
import slimeknights.mantle.client.screen.SliderWidget;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.RenderUtils;
import slimeknights.tconstruct.shared.TinkerClient;
import slimeknights.tconstruct.tables.client.inventory.widget.BorderWidget;

public class InfoPanelScreen
extends ModuleScreen {
    private static final int resW = 118;
    private static final int resH = 75;
    private static final class_2561 DEFAULT_CAPTION = TConstruct.makeTranslation("gui", "caption").method_27692(class_124.field_1073);
    protected static class_2960 BACKGROUND_IMAGE = TConstruct.getResource("textures/gui/panel.png");
    protected static final ElementScreen TOP_LEFT = new ElementScreen(0, 0, 4, 4, 256, 256);
    protected static final ElementScreen TOP_RIGHT = new ElementScreen(122, 0, 4, 4);
    protected static final ElementScreen BOTTOM_LEFT = new ElementScreen(0, 79, 4, 4);
    protected static final ElementScreen BOTTOM_RIGHT = new ElementScreen(122, 79, 4, 4);
    protected static final ScalableElementScreen TOP = new ScalableElementScreen(4, 0, 118, 4);
    protected static final ScalableElementScreen BOTTOM = new ScalableElementScreen(4, 79, 118, 4);
    protected static final ScalableElementScreen LEFT = new ScalableElementScreen(0, 4, 4, 75);
    protected static final ScalableElementScreen RIGHT = new ScalableElementScreen(122, 4, 4, 75);
    protected static final ScalableElementScreen BACKGROUND = new ScalableElementScreen(4, 4, 118, 75);
    protected static final ElementScreen SLIDER_NORMAL = new ElementScreen(0, 83, 3, 5);
    protected static final ElementScreen SLIDER_HOVER = SLIDER_NORMAL.shift(InfoPanelScreen.SLIDER_NORMAL.w, 0);
    protected static final ScalableElementScreen SLIDER_BAR = new ScalableElementScreen(0, 88, 3, 8);
    protected static final ElementScreen SLIDER_TOP = new ElementScreen(3, 88, 3, 4);
    protected static final ElementScreen SLIDER_BOTTOM = new ElementScreen(3, 92, 3, 4);
    protected BorderWidget border = new BorderWidget();
    protected SliderWidget slider = new SliderWidget(SLIDER_NORMAL, SLIDER_HOVER, SLIDER_HOVER, SLIDER_TOP, SLIDER_BOTTOM, SLIDER_BAR);
    protected class_2561 caption;
    protected List<class_2561> text;
    protected List<class_2561> tooltips;
    protected List<Integer> tooltipLines = Lists.newLinkedList();
    protected float textScale = 1.0f;

    public InfoPanelScreen(MultiModuleScreen parent, class_1703 container, class_1661 playerInventory, class_2561 title) {
        super(parent, container, playerInventory, title, true, false);
        this.border.borderTop = TOP;
        this.border.borderBottom = BOTTOM;
        this.border.borderLeft = LEFT;
        this.border.borderRight = RIGHT;
        this.border.cornerTopLeft = TOP_LEFT;
        this.border.cornerTopRight = TOP_RIGHT;
        this.border.cornerBottomLeft = BOTTOM_LEFT;
        this.border.cornerBottomRight = BOTTOM_RIGHT;
        this.field_2792 = 126;
        this.field_2779 = 83;
        this.caption = DEFAULT_CAPTION;
        this.text = Lists.newLinkedList();
    }

    public int getScaledFontHeight() {
        Objects.requireNonNull(this.field_22793);
        return (int)Math.ceil(9.0f * this.textScale);
    }

    @Override
    public void updatePosition(int parentX, int parentY, int parentSizeX, int parentSizeY) {
        super.updatePosition(parentX, parentY, parentSizeX, parentSizeY);
        this.border.setPosition(this.field_2776, this.field_2800);
        this.border.setSize(this.field_2792, this.field_2779);
        this.slider.setPosition(this.guiRight() - this.border.w - 2, this.field_2800 + this.border.h + 12);
        this.slider.setSize(this.field_2779 - this.border.h * 2 - 2 - 12);
        this.updateSliderParameters();
    }

    public void setCaption(class_2561 caption) {
        this.caption = caption.method_27661().method_27692(class_124.field_1073);
        this.updateSliderParameters();
    }

    public void setText(class_2561 ... text) {
        ArrayList<class_2561> textComponents = new ArrayList<class_2561>(Arrays.asList(text));
        this.setText(textComponents, null);
    }

    public void setText(List<class_2561> text) {
        this.setText(text, null);
    }

    public void setText(List<class_2561> text, @Nullable List<class_2561> tooltips) {
        this.text = text;
        this.updateSliderParameters();
        this.setTooltips(tooltips);
    }

    protected void setTooltips(@Nullable List<class_2561> tooltips) {
        this.tooltips = tooltips;
    }

    public boolean hasCaption() {
        return this.caption != null && !this.caption.getString().isEmpty();
    }

    public boolean hasTooltips() {
        return this.tooltips != null && !this.tooltips.isEmpty();
    }

    public boolean hasInitialized() {
        return this.field_22793 != null;
    }

    public int calcNeededHeight() {
        int neededHeight = 0;
        if (!this.hasInitialized()) {
            return this.field_22790;
        }
        int scaledFontHeight = this.getScaledFontHeight();
        if (this.hasCaption()) {
            neededHeight += scaledFontHeight;
            neededHeight += 3;
        }
        neededHeight = (int)((float)neededHeight + ((float)scaledFontHeight + 0.5f) * (float)this.getTotalLines().size());
        return neededHeight;
    }

    protected void updateSliderParameters() {
        this.slider.hide();
        int h = this.field_2779 - 10;
        if (this.calcNeededHeight() <= h) {
            return;
        }
        this.slider.show();
        int scaledFontHeight = this.getScaledFontHeight();
        int neededHeight = this.calcNeededHeight();
        int hiddenRows = (neededHeight - h) / scaledFontHeight;
        if ((neededHeight - h) % scaledFontHeight > 0) {
            ++hiddenRows;
        }
        this.slider.setSliderParameters(0, hiddenRows, 1);
    }

    protected List<class_5481> getTotalLines() {
        int w = this.field_2792 - this.border.w * 2 + 2;
        if (!this.slider.isHidden()) {
            w -= this.slider.width + 3;
        }
        w = (int)((float)w / this.textScale);
        LinkedList lines = Lists.newLinkedList();
        this.tooltipLines.clear();
        for (class_2561 textComponent : this.text) {
            this.tooltipLines.add(lines.size());
            if (textComponent.getString().isEmpty()) {
                lines.add(class_2561.method_43473().method_30937());
                continue;
            }
            lines.addAll(this.field_22793.method_1728((class_5348)textComponent, w));
        }
        return lines;
    }

    public InfoPanelScreen wood() {
        this.shift(126, 0);
        this.shiftSlider(6, 0);
        return this;
    }

    public InfoPanelScreen metal() {
        this.shift(126, 83);
        this.shiftSlider(12, 0);
        return this;
    }

    private void shift(int xd, int yd) {
        this.border.borderTop = TOP.shift(xd, yd);
        this.border.borderBottom = BOTTOM.shift(xd, yd);
        this.border.borderLeft = LEFT.shift(xd, yd);
        this.border.borderRight = RIGHT.shift(xd, yd);
        this.border.cornerTopLeft = TOP_LEFT.shift(xd, yd);
        this.border.cornerTopRight = TOP_RIGHT.shift(xd, yd);
        this.border.cornerBottomLeft = BOTTOM_LEFT.shift(xd, yd);
        this.border.cornerBottomRight = BOTTOM_RIGHT.shift(xd, yd);
    }

    private void shiftSlider(int xd, int yd) {
        this.slider = new SliderWidget(SLIDER_NORMAL.shift(xd, yd), SLIDER_HOVER.shift(xd, yd), SLIDER_HOVER.shift(xd, yd), SLIDER_TOP.shift(xd, yd), SLIDER_BOTTOM.shift(xd, yd), SLIDER_BAR.shift(xd, yd));
    }

    protected void method_2388(class_332 graphics, int x, int y) {
    }

    protected void method_2380(class_332 graphics, int mouseX, int mouseY) {
        int i;
        super.method_2380(graphics, mouseX, mouseY);
        if (this.tooltips == null) {
            return;
        }
        if (mouseX < this.field_2776 || mouseX > this.guiRight()) {
            return;
        }
        int scaledFontHeight = this.getScaledFontHeight();
        if (this.hasTooltips() && mouseX >= this.guiRight() - this.border.w - this.field_22793.method_1727("?") / 2 && mouseX < this.guiRight() && mouseY > this.field_2800 + 5 && mouseY < this.field_2800 + 5 + scaledFontHeight) {
            graphics.method_51447(this.field_22793, this.field_22793.method_1728((class_5348)class_2561.method_43471((String)"gui.tconstruct.general.hover"), 150), mouseX - 155, mouseY);
        }
        float y = this.getTooltipStart(5 + this.field_2800);
        Objects.requireNonNull(this.field_22793);
        float textHeight = (9.0f + 0.5f) * this.textScale;
        float lowerBound = this.field_2800 + this.field_2779 - 5;
        int index = -1;
        ListIterator<class_5481> iter = this.getTotalLines().listIterator(this.slider.getValue());
        while (iter.hasNext() && !(y + textHeight > lowerBound)) {
            if ((float)mouseY > y && (float)mouseY <= y + textHeight) {
                index = iter.nextIndex();
                break;
            }
            iter.next();
            y += textHeight;
        }
        if (index < 0) {
            return;
        }
        for (i = 0; this.tooltipLines.size() > i && index > this.tooltipLines.get(i); ++i) {
        }
        if (i >= this.tooltips.size() || this.tooltips.get(i).getString().isEmpty()) {
            return;
        }
        int w = class_3532.method_15340((int)(this.field_22789 - mouseX - 12), (int)0, (int)200);
        if (w < 100) {
            mouseX -= 100 - w;
            w = 100;
        }
        List lines = this.field_22793.method_1728((class_5348)this.tooltips.get(i), w);
        graphics.method_51447(this.field_22793, lines, mouseX, mouseY - lines.size() * this.getScaledFontHeight() / 2);
    }

    protected float getTooltipStart(float y) {
        if (this.hasCaption()) {
            y += (float)(this.getScaledFontHeight() + 3);
        }
        return y;
    }

    protected void method_2389(class_332 graphics, float partialTicks, int mouseX, int mouseY) {
        RenderUtils.setup(BACKGROUND_IMAGE);
        this.border.draw(graphics, BACKGROUND_IMAGE);
        BACKGROUND.drawScaled(graphics, BACKGROUND_IMAGE, this.field_2776 + 4, this.field_2800 + 4, this.field_2792 - 8, this.field_2779 - 8);
        float y = 5 + this.field_2800;
        float x = 5 + this.field_2776;
        int color = -986896;
        if (this.hasTooltips()) {
            graphics.method_51433(this.field_22793, "?", this.guiRight() - this.border.w - this.field_22793.method_1727("?") / 2, this.field_2800 + 5, -10526881, false);
        }
        int scaledFontHeight = this.getScaledFontHeight();
        if (this.hasCaption()) {
            int x2 = this.field_2792 / 2;
            TinkerClient.drawString(graphics, this.field_22793, this.caption.method_30937(), this.field_2776 + (x2 -= this.field_22793.method_27525((class_5348)this.caption) / 2), y, color, true);
            y += (float)(scaledFontHeight + 3);
        }
        if (this.text == null || this.text.size() == 0) {
            return;
        }
        Objects.requireNonNull(this.field_22793);
        float textHeight = 9.0f + 0.5f;
        float lowerBound = (float)(this.field_2800 + this.field_2779 - 5) / this.textScale;
        graphics.method_51448().method_22903();
        graphics.method_51448().method_22905(this.textScale, this.textScale, 1.0f);
        x /= this.textScale;
        y /= this.textScale;
        ListIterator<class_5481> iter = this.getTotalLines().listIterator(this.slider.getValue());
        while (iter.hasNext() && !(y + textHeight - 0.5f > lowerBound)) {
            class_5481 line = iter.next();
            TinkerClient.drawString(graphics, this.field_22793, line, x, y, color, true);
            y += textHeight;
        }
        graphics.method_51448().method_22909();
        RenderUtils.setup(BACKGROUND_IMAGE);
        this.slider.update(mouseX, mouseY);
        this.slider.draw(graphics, BACKGROUND_IMAGE);
    }

    @Override
    public boolean handleMouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (!this.slider.isEnabled()) {
            return false;
        }
        if (mouseButton == 0 && mouseX >= (double)this.slider.xPos && mouseY >= (double)this.slider.yPos && mouseX <= (double)(this.slider.xPos + this.slider.width) && mouseY <= (double)(this.slider.yPos + this.slider.height)) {
            this.slider.handleMouseClicked((int)mouseX, (int)mouseY, mouseButton);
            return true;
        }
        return false;
    }

    @Override
    public boolean handleMouseReleased(double mouseX, double mouseY, int state) {
        if (!this.slider.isEnabled()) {
            return false;
        }
        this.slider.handleMouseReleased();
        return mouseX >= (double)this.slider.xPos && mouseY >= (double)this.slider.yPos && mouseX <= (double)(this.slider.xPos + this.slider.width) && mouseY <= (double)(this.slider.yPos + this.slider.height);
    }

    @Override
    public boolean handleMouseScrolled(double mouseX, double mouseY, double scrollData) {
        if (!this.slider.isEnabled() || !this.isMouseInModule((int)mouseX, (int)mouseY) || this.isMouseOverFullSlot(mouseX, mouseY)) {
            return false;
        }
        return this.slider.mouseScrolled(scrollData, true);
    }

    public void setTextScale(float textScale) {
        this.textScale = textScale;
    }
}

